var stateNormal = 1;
var statePressed = 2;
var stateDisabled = 3;
var stateHidden = 4;

var typeButton = 0;
var typePlaceholder = 1;
var typeSlider = 2;
var typeInfoDisplay = 3;

var stateStopped = 0;
var statePaused = 1;
var statePlaying = 2;
var stateWaiting = 3;

function OnInitialize()
{
	if(Metamorphis.LoadSkinState() == false)
	{
		var x = Player.Left;
		var y = Player.Top;
		
		Vol.SetWindowPos(x + 13, y - 50);
		Vol.ShowWindow(true);
		
		var ButtonVol = Vol.GetSkinItem(typeButton, "ToggleVol");
		ButtonVol.State = statePressed;
		ButtonVol.Tooltip = "Hide Volume / Position";

		var ButtonMute = Vol.GetSkinItem(typeButton, "ToggleMute");
			if(GetMJMixer().Mute == 1 )
				{
				ButtonMute.State = statePressed;
				ButtonMute.Tooltip = "Unmute Sound";
				} 
				else
				{
				ButtonMute.State = stateNormal;
				ButtonMute.Tooltip = "Mute Sound";			
				}
	
		EQ.SetWindowPos(x + 266, y + 7);
		EQ.ShowWindow(true);
		
		var ButtonEQ = EQ.GetSkinItem(typeButton, "ToggleEqualizer");
		ButtonEQ.State = statePressed;
		ButtonEQ.Tooltip = "Hide Equalizer";

		var ButtonTog = EQ.GetSkinItem(typeButton, "EQToggle");
			if(GetMJMixer().EQOn == 1 )
				{
				ButtonTog.State = statePressed;
				ButtonTog.Tooltip = "Off EQ";
				} 
				else
				{
				ButtonTog.State = stateNormal;
				ButtonTog.Tooltip = "On EQ";			
				}

		Visualization.SetWindowPos(x - 174, y - 10);
		Visualization.ShowWindow(true);
		
		var ButtonVis = Player.GetSkinItem(typeButton, "ToggleVisualization");
		ButtonVis.State = statePressed;
		ButtonVis.Tooltip = "Hide Visualization";
		
		Playlist.SetWindowPos(x + 20, y + 133);
		Playlist.ShowWindow(true);
		
		var ButtonPl = Playlist.GetSkinItem(typeButton, "TogglePlaylist");
		ButtonPl.State = statePressed;
		ButtonPl.Tooltip = "Hide Playlist";

		Pltemp.SetWindowPos(x + 20, y + 134);
		Pltemp.ShowWindow(false);
		
		var ButtonPltemp = Pltemp.GetSkinItem(typeButton, "TogglePlaylist");
		ButtonPltemp.State = stateNormal;
		ButtonPltemp.Tooltip = "Show Playlist";

		
	}
	
	Player.GetSkinItem(typePlaceholder, "StopStat").SetBitmap("stopstat.gif", "00FF00");
	OnPlayStateChanged();	
}


function OnExit()
{
	Metamorphis.SaveSkinState();
}

function OnToggleVolButton()
{   	
	var x = Player.Left;
	var y = Player.Top;

	var Button = Vol.GetSkinItem(typeButton, "ToggleVol");
	if(Vol.Top > y - 41)
	{
		Vol.ShowWindow(true);
		Vol.MoveWindowAnimated(0, -41, 10);
		
		Button.State = statePressed;
		Button.Tooltip = "Hide Volume / Position";
	} 
	else
	{
		Vol.SetWindowBehind(Player);
		Vol.MoveWindowAnimated(0, 41, 10);
		Vol.ShowWindow(true);
			
		Button.State = stateNormal;
		Button.Tooltip = "Show Volume / Position";			
	}
}

function OnToggleMuteButton()
{   	
	var Button = Vol.GetSkinItem(typeButton, "ToggleMute");
	if(GetMJMixer().Mute == 0 )
	{
		Button.State = statePressed;
		Button.Tooltip = "Unmute Sound";
	} 
	else
	{
		Button.State = stateNormal;
		Button.Tooltip = "Mute Sound";			
	}
}


function OnToggleEqButton()
{	
	var x = Player.Left;
	var y = Player.Top;
	
	var Button = EQ.GetSkinItem(typeButton, "ToggleEqualizer");
	if(EQ.Left + 10 > x + 267)
	{
		
		EQ.SetWindowBehind(Player);
		EQ.MoveWindowAnimated( -210, 0, 20);
		EQ.ShowWindow(true);
		
		Button.State = stateNormal;
		Button.Tooltip = "Show Equalizer";	
	}
	else
	{
		EQ.ShowWindow(true);
		EQ.MoveWindowAnimated(210,  0, 20);		
		
		Button.State = statePressed;
		Button.Tooltip = "Hide Equalizer";	
	}
}
function OnToggleOnButton()
{   	
	var Button = EQ.GetSkinItem(typeButton, "EQToggle");
	if(GetMJMixer().EQOn == 1 )
	{
		Button.State = statePressed;
		Button.Tooltip = "Off EQ";
	} 
	else
	{
		Button.State = stateNormal;
		Button.Tooltip = "On EQ";			
	}
}
function OnToggleVisualization()
{		
	var Button = Player.GetSkinItem(typeButton, "ToggleVisualization");
	if(Visualization.IsWindowVisible())
	{
		
		Visualization.ShowWindow(false);
	
		Button.State = stateNormal;
		Button.Tooltip = "Show Visualization";	
	}
	else
	{	
		Visualization.ShowWindow(true);
	
		Button.State = statePressed;
		Button.Tooltip = "Hide Visualization";	
	}
}

function OnTogglePlaylist()
{		
	var x = Player.Left;
	var y = Player.Top;
	
	var Button = Playlist.GetSkinItem(typeButton, "TogglePlaylist");
	if(Playlist.Top + 120 > y + 154)
	{

		Playlist.SetWindowBehind(Player);
		Playlist.SetWindowBehind(EQ);
		Playlist.MoveWindowAnimated( 0, -110, 20);
		Playlist.ShowWindow(false);		
		Pltemp.ShowWindow(true);
		
		Button.State = stateNormal;
		Button.Tooltip = "Show Playlist";	
	}
	else
	{	
		Playlist.MoveWindowAnimated( 0, 110, 20);
		Playlist.ShowWindow(true);
		Pltemp.ShowWindow(false);

		Button.State = stateNormal;
		Button.Tooltip = "Hide Playlist";	
	}
}

function OnPlayStateChanged()
{
	var PlayState = MJAutomation.GetPlayback().State;

	if(PlayState == statePlaying)
	{
		Visualization.GetSkinItem(typePlaceholder, "Visualization").State = stateNormal;
		Player.GetSkinItem(typePlaceholder, "PlayStat").State = stateNormal;
		Player.GetSkinItem(typePlaceholder, "PauseStat").State = stateHidden;
		Player.GetSkinItem(typePlaceholder, "StopStat").State = stateHidden;
	}
	else if(PlayState == stateStopped)
	{

		Visualization.GetSkinItem(typePlaceholder, "Visualization").State = stateHidden;
		Player.GetSkinItem(typePlaceholder, "StopStat").State = stateNormal;
		Player.GetSkinItem(typePlaceholder, "PlayStat").State = stateHidden;
		Player.GetSkinItem(typePlaceholder, "PauseStat").State = stateHidden;
	}
	else
	{
		Player.GetSkinItem(typePlaceholder, "PauseStat").State = stateNormal;
		Player.GetSkinItem(typePlaceholder, "PlayStat").State = stateHidden;
		Player.GetSkinItem(typePlaceholder, "StopStat").State = stateHidden;
	}

}

